/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder;

import io.github.fabricators_of_create.porting_lib.event.client.ClientWorldEvents;
import io.github.fabricators_of_create.porting_lib.event.client.OverlayRenderCallback;
import io.github.fabricators_of_create.porting_lib.event.client.RenderTooltipBorderColorCallback;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.createmod.catnip.placement.PlacementClient;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.PonderClient;
import net.createmod.ponder.enums.PonderConfig;
import net.createmod.ponder.enums.PonderKeybinds;
import net.createmod.ponder.foundation.PonderTooltipHandler;
import net.createmod.ponder.utility.FabricClientResourceReloadListener;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import org.jetbrains.annotations.Nullable;

public class FabricPonderClient
implements ClientModInitializer {
    public static final FabricClientResourceReloadListener FABRIC$RESOURCE_RELOAD_LISTENER = new FabricClientResourceReloadListener();

    public void onInitializeClient() {
        PonderClient.init();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            PonderClient.onTick();
            PonderTooltipHandler.tick();
        });
        ClientWorldEvents.LOAD.register((client, world) -> PonderClient.onLoadWorld((class_1936)world));
        ClientWorldEvents.UNLOAD.register((client, world) -> PonderClient.onUnloadWorld((class_1936)world));
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> PonderClient.onRenderWorld(context.matrixStack()));
        OverlayRenderCallback.EVENT.register((stack, partialTicks, window, type) -> {
            if (type != OverlayRenderCallback.Types.CROSSHAIRS) {
                return false;
            }
            PlacementClient.onRenderCrosshairOverlay(window, stack, partialTicks);
            return false;
        });
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> PonderTooltipHandler.addToTooltip(lines, stack));
        RenderTooltipBorderColorCallback.EVENT.register(FabricPonderClient::getItemTooltipColor);
        PonderKeybinds.register(KeyBindingHelper::registerKeyBinding);
        ClientLifecycleEvents.CLIENT_STARTED.register(FabricPonderClient::onClientStarted);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)FABRIC$RESOURCE_RELOAD_LISTENER);
        this.prepareConfigUI();
    }

    private void prepareConfigUI() {
        BaseConfigScreen.setDefaultActionFor("ponder", base -> base.withButtonLabels("Client Settings", null, null).withSpecs(PonderConfig.Client().specification, null, null));
    }

    private static void onClientStarted(class_310 client) {
        PonderClient.modLoadCompleted();
    }

    @Nullable
    public static RenderTooltipBorderColorCallback.BorderColorEntry getItemTooltipColor(class_1799 stack, int originalBorderColorStart, int originalBorderColorEnd) {
        return PonderTooltipHandler.handleTooltipColor(stack).map(colors -> new RenderTooltipBorderColorCallback.BorderColorEntry(((Color)colors.getFirst()).getRGB(), ((Color)colors.getSecond()).getRGB())).orElse(null);
    }
}

